# 画面設計書 11-Restart Unit Test

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）におけるRestart Unit Test画面（Page 11）の設計書である。個別のUnit Testを再実行するためのモーダルダイアログ画面について、その構成、機能、データフローを定義する。

### 本画面の処理概要

本画面は、特定のQUASTOルールとスキームに対するUnit Testを手動で再実行するためのモーダルダイアログである。

**業務上の目的・背景**：定期実行されるUnit Testとは別に、特定のルールとスキームの組み合わせに対して即座にテストを再実行したい場合がある。例えば、ルール違反を修正した後に修正結果を確認したい場合や、特定のスキームのみをテスト対象として検証したい場合に本画面を使用する。これにより、全体のCronジョブ実行を待たずに迅速なフィードバックを得ることができる。

**画面へのアクセス方法**：Dashboard画面（Page 1）のテスト実行レポートにおいて、各テスト結果行の「Restart」リンクをクリックすることでモーダルダイアログとして開く。Dashboard画面からRule Number、Client Name、Scheme Nameがパラメータとして渡される。

**主要な操作・処理内容**：
1. Rule Number、Client Name、Scheme Nameの確認（表示専用項目として参照）
2. Restart Unit Testボタンを押下してUnit Testジョブを作成・実行
3. ジョブ実行中はUnit Test in progress...ボタンが表示され、Refreshボタンで状態を更新
4. Job Historyリージョンで過去のジョブ実行履歴を確認

**画面遷移**：
- 遷移元：Dashboard画面（Page 1）のRestartリンク
- 遷移先：なし（モーダルダイアログのため、Closeボタンで親画面に戻る）

**権限による表示制御**：本画面はログイン認証が必要（p_protection_level=>'C'）。特定のロールによる表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | 単一ユニットテスト実行 | 主機能 | 指定したルール・スキームのユニットテストを再実行 |
| 18 | カスタムテストジョブ作成 | 主機能 | 単一ユニットテスト実行用のスケジューラジョブを作成 |

## 画面種別

モーダルダイアログ（詳細表示・操作実行）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| Page ID | 11 |
| Page Alias | RESTART-UNIT-TEST |
| Page Mode | MODAL |
| Dialog Width | 1000px |
| URL形式 | `f?p=141:11:&SESSION.::NO::P11_RULE_NUMBER,P11_CLIENT_NAME,P11_SCHEME_NAME:<rule_number>,<client_name>,<scheme_name>` |

## 入出力項目

### 入力パラメータ（URLから受け取る）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| Rule Number | P11_RULE_NUMBER | VARCHAR2 | Yes | 再実行対象のルール番号 |
| Client Name | P11_CLIENT_NAME | VARCHAR2 | Yes | 再実行対象のクライアント名 |
| Scheme Name | P11_SCHEME_NAME | VARCHAR2 | Yes | 再実行対象のスキーム名 |

### 非表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| Custom Job Name | P11_CUSTOM_JOB_NAME | VARCHAR2 | 自動計算されるジョブ名（Job History絞り込み用） |

## 表示項目

### Restart Unit Testリージョン

| 項目名 | 項目ID | 表示タイプ | 説明 |
|--------|--------|------------|------|
| Rule Number | P11_RULE_NUMBER | Display Only | 実行対象のルール番号を表示 |
| Client Name | P11_CLIENT_NAME | Display Only | 実行対象のクライアント名を表示 |
| Scheme Name | P11_SCHEME_NAME | Display Only | 実行対象のスキーム名を表示 |

### Job Historyリージョン（Classic Report）

| 列名 | データ型 | 表示形式 | 説明 |
|------|----------|----------|------|
| JOB_NAME | VARCHAR2 | 非表示 | ジョブ名（内部利用） |
| LOG_DATE | TIMESTAMP | MM/DD/YYYY HH24:MI | ジョブ実行日時 |
| STATUS | VARCHAR2 | テキスト | ジョブ実行ステータス（SUCCEEDED/ERROR等） |
| ERROR# | NUMBER | 右寄せ数値 | エラーコード |
| ERRORS | VARCHAR2 | テキスト | エラー詳細メッセージ |
| RUN_DURATION | VARCHAR2 | HH:MI:SS形式 | ジョブ実行時間 |

## イベント仕様

### 1-Restart Unit Testボタン押下

**トリガー条件**：カスタムジョブが存在しない場合（`QA_UNIT_TESTS_PKG.f_exists_custom_job() = 'N'`）にのみ表示

**処理フロー**：
1. フォームをサブミット
2. AFTER_SUBMITプロセス「Create Job」が実行される
3. `qa_unit_tests_pkg.p_create_custom_unit_test_job`を呼び出し
4. DBMSスケジューラジョブを作成（5秒後に実行開始）
5. 成功メッセージ「Job started.」を表示

**データの流れ**：
```
[P11_RULE_NUMBER, P11_CLIENT_NAME, P11_SCHEME_NAME]
    |
    v
[qa_unit_tests_pkg.p_create_custom_unit_test_job]
    |
    v
[DBMS_SCHEDULER.CREATE_JOB] --> [USER_SCHEDULER_JOBS]
    |
    v (5秒後)
[qa_unit_tests_pkg.p_run_custom_unit_test]
    |
    v
[QA_TEST_RESULTS, QA_TEST_RUNS]
```

### 2-Unit Test in progressボタン表示

**トリガー条件**：カスタムジョブが存在する場合（`QA_UNIT_TESTS_PKG.f_exists_custom_job() = 'Y'`）

**動作**：
- ボタンは無効化状態（disabled）で表示
- スピニングアイコン（fa-refresh fa-anim-spin）を表示
- 押下してもバリデーションは実行されない

### 3-Refreshボタン押下

**トリガー条件**：カスタムジョブが存在する場合（`QA_UNIT_TESTS_PKG.f_exists_custom_job() = 'Y'`）

**処理フロー**：
1. Dynamic Action「Refresh Page」がトリガー
2. JavaScript `location.reload()` を実行
3. ページ全体を再読み込み

### 4-Closeボタン押下

**処理フロー**：
1. Dynamic Action「Close Dialog」がトリガー
2. NATIVE_DIALOG_CLOSE アクションを実行
3. モーダルダイアログを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Restart Unit Testボタン押下 | USER_SCHEDULER_JOBS | INSERT（via DBMS_SCHEDULER） | カスタムUnit Testジョブを作成 |
| ジョブ実行完了時 | QA_TEST_RESULTS | INSERT | Unit Test結果XMLを格納 |
| ジョブ実行完了時 | QA_TEST_RUNS | INSERT | テスト実行履歴を格納 |
| ジョブ実行完了時 | QA_TEST_RUN_INVALID_OBJECTS | INSERT | 無効オブジェクト詳細を格納 |

### テーブル別更新項目詳細

#### USER_SCHEDULER_JOBS（DBMS_SCHEDULER経由）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | JOB_NAME | `QUASTO_UNIT_TEST_JOB_<SCHEME>_<CLIENT>_<RULE>_<TIMESTAMP>` | f_get_job_nameで生成 |
| INSERT | JOB_TYPE | 'PLSQL_BLOCK' | 固定値 |
| INSERT | JOB_ACTION | `BEGIN qa_unit_tests_pkg.p_run_custom_unit_test(...); END;` | 実行するPL/SQLブロック |
| INSERT | START_DATE | SYSTIMESTAMP + INTERVAL '5' SECOND | 5秒後に実行開始 |
| INSERT | ENABLED | TRUE | 有効状態で作成 |
| INSERT | AUTO_DROP | TRUE | 実行完了後に自動削除 |

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | QATR_XML_RESULT | utPLSQL実行結果XML | JUnit形式XML |
| INSERT | QATR_DESCRIPTION | 'Executed by PL/SQL Call: <プログラム名>' | 実行方法の説明 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | Job started. | ジョブ作成成功時 |
| MSG-002 | 情報 | No custom Jobs have run recently for this rule, client and scheme. | Job Historyにデータがない場合 |
| MSG-003 | 情報 | Click on the following Button to let the database scheduler rerun the Unit Test of the given rule and scheme. | 画面表示時（Infoリージョン） |
| MSG-004 | 情報 | The following report shows the execution status of recent runs of scheduler jobs... | Job History Infoリージョン |

## 例外処理

| 例外パターン | 発生条件 | 画面の挙動 |
|-------------|---------|------------|
| ジョブ作成エラー | DBMS_SCHEDULER権限不足等 | INLINE_IN_NOTIFICATIONでエラー表示 |
| 入力パラメータ不正 | 必須パラメータがNULL | -20001エラー発生、ログ記録 |
| Unit Testパッケージ未生成 | 対象スキームのUnit Testパッケージが存在しない | ジョブ実行時にエラー、QA_TEST_RUNSにエラー記録 |

## 備考

- Job Historyレポートは5件ずつ表示（NEXT/PREVIOUSページネーション）
- Job Historyは遅延読み込み（Lazy Loading）が有効
- ジョブ名フォーマット：`QUASTO_UNIT_TEST_JOB_<SCHEME>_<CLIENT>_<RULE>_<YYYYMMDDHH24MISS>`
- ジョブは自動削除（auto_drop=true）のため、実行完了後はUSER_SCHEDULER_JOBSから消える
- 実行履歴はUSER_SCHEDULER_JOB_RUN_DETAILSから取得（ビュー：qa_job_run_details_p0011_v）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で使用されるデータ構造とビュー定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_job_run_details_p0011_v.sql | `src/plsql/vw/qa_job_run_details_p0011_v.sql` | Job Historyレポートのデータソースとなるビュー定義。USER_SCHEDULER_JOB_RUN_DETAILSからカスタムジョブの実行履歴を取得 |

**読解のコツ**: このビューはOracle標準のUSER_SCHEDULER_JOB_RUN_DETAILSビューをラップし、Cronjobを除外しつつRUN_DURATIONをHH:MI:SS形式にフォーマットしている。

#### Step 2: エントリーポイントを理解する

画面定義ファイルでUI構成とイベント処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | モーダルダイアログ定義、ボタン条件、Dynamic Action、プロセス定義 |

**主要処理フロー**:
1. **行14-25**: ページ基本定義（モーダル、幅1000px）
2. **行189-208**: Restart Unit Testボタン定義（条件付き表示）
3. **行209-230**: Unit Test in progressボタン定義（ジョブ存在時）
4. **行363-378**: Create Jobプロセス（p_create_custom_unit_test_job呼び出し）

#### Step 3: ビジネスロジックを理解する

Unit Test実行のコアロジックを含むパッケージを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | カスタムジョブ作成、Unit Test実行、結果保存のロジック |

**主要処理フロー**:
- **行873-916**: `p_create_custom_unit_test_job` - スケジューラジョブ作成
- **行990-1036**: `p_run_custom_unit_test` - 個別Unit Test実行
- **行1170-1220**: `f_get_job_name` - ジョブ名生成ロジック
- **行1222-1267**: `f_exists_custom_job` - ジョブ存在確認

### プログラム呼び出し階層図

```
[Page 11: Restart Unit Test画面]
    │
    ├─ [Restart Unit Testボタン押下]
    │      │
    │      └─ [Process: Create Job]
    │             │
    │             └─ qa_unit_tests_pkg.p_create_custom_unit_test_job
    │                    │
    │                    ├─ f_get_job_name (ジョブ名生成)
    │                    │
    │                    └─ DBMS_SCHEDULER.CREATE_JOB
    │                           │
    │                           └─ (5秒後実行)
    │                                  │
    │                                  └─ qa_unit_tests_pkg.p_run_custom_unit_test
    │                                         │
    │                                         ├─ f_get_unit_test_call
    │                                         │
    │                                         ├─ ut.run (utPLSQL実行)
    │                                         │
    │                                         └─ INSERT INTO QA_TEST_RESULTS
    │
    ├─ [ボタン表示条件判定]
    │      │
    │      └─ qa_unit_tests_pkg.f_exists_custom_job
    │             │
    │             └─ SELECT FROM USER_SCHEDULER_JOBS
    │
    └─ [Job History Report]
           │
           └─ qa_job_run_details_p0011_v
                  │
                  └─ USER_SCHEDULER_JOB_RUN_DETAILS
```

### データフロー図

```
[入力]                    [処理]                           [出力]

P11_RULE_NUMBER    ───┐
P11_CLIENT_NAME    ───┼──▶ p_create_custom_unit_test_job ──▶ USER_SCHEDULER_JOBS
P11_SCHEME_NAME    ───┘           │
                                  │
                                  ▼ (5秒後自動実行)
                         p_run_custom_unit_test
                                  │
                                  ├──▶ ut.run() ──▶ XML Result
                                  │
                                  └──▶ QA_TEST_RESULTS
                                       QA_TEST_RUNS
                                       QA_TEST_RUN_INVALID_OBJECTS

[Job History表示]
qa_job_run_details_p0011_v ◀── USER_SCHEDULER_JOB_RUN_DETAILS
        │
        └──▶ History Report Region
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | ソース | 画面定義（APEX Page） |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | Unit Test実行ロジック |
| qa_job_run_details_p0011_v.sql | `src/plsql/vw/qa_job_run_details_p0011_v.sql` | ソース | ジョブ実行履歴ビュー |
| qa_constant_pkg.sql | `src/plsql/pkg/qa_constant_pkg.sql` | ソース | 定数定義（ジョブ名プレフィックス等） |
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | 文字列変換ユーティリティ |
